/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.primary.natures;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.primary.natures.IPrimaryNatureContributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryNaturesManager {
    private final String EXTENSION_POINT = "primaryNatureContributors";
    private final String ELEMENT_CONTRIBUTOR = "contributor";
    private final String ELEMENT_NATURE_ID = "natureId";
    private final String ELEMENT_CLASS = "class";
    private static PrimaryNaturesManager INSTANCE;
    private Map<String, IPrimaryNatureContributor> natureIdRanks;

    public static synchronized PrimaryNaturesManager getManager() {
        if (INSTANCE == null) {
            INSTANCE = new PrimaryNaturesManager();
        }
        return INSTANCE;
    }

    private PrimaryNaturesManager() {
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.core.epl", (String)"primaryNatureContributors", (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                PrimaryNaturesManager.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{"contributor"});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        String contributorClass;
        if ("contributor".equals(element.getName()) && !StringUtil.isEmpty((String)(contributorClass = element.getAttribute("class")))) {
            try {
                IPrimaryNatureContributor natureRankContributor = (IPrimaryNatureContributor)element.createExecutableExtension("class");
                String natureId = element.getAttribute("natureId");
                this.natureIdRanks.put(natureId, natureRankContributor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public List<String> getPotentialNatures(IProject project) {
        if (project == null || !project.isAccessible()) {
            return Collections.emptyList();
        }
        return this.getPotentialNaturesFromPath(project.getLocation());
    }

    public List<String> getPotentialNaturesFromPath(IPath path) {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        this.lazyInit();
        ArrayList<String> potentialNatures = new ArrayList<String>(this.natureIdRanks.size());
        for (String natureId : this.natureIdRanks.keySet()) {
            IPrimaryNatureContributor primaryNatureContributor = this.natureIdRanks.get(natureId);
            int primaryNatureRank = primaryNatureContributor.getPrimaryNatureRank(path);
            if (primaryNatureRank == 1) {
                potentialNatures.add(natureId);
                continue;
            }
            if (primaryNatureRank != 2) continue;
            potentialNatures.add(0, natureId);
        }
        return potentialNatures;
    }

    public IPrimaryNatureContributor getPrimaryNatureContributor(String natureId) {
        this.lazyInit();
        return this.natureIdRanks.get(natureId);
    }

    public Map<String, IPrimaryNatureContributor> getContributorsMap() {
        this.lazyInit();
        return this.natureIdRanks;
    }

    private synchronized void lazyInit() {
        if (this.natureIdRanks == null) {
            this.natureIdRanks = new HashMap<String, IPrimaryNatureContributor>();
            this.readExtensionRegistry();
        }
    }
}

